/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wut.recipe;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import de.mari_023.ae2wtlib.wut.recipe.Combine;
import de.mari_023.ae2wtlib.wut.recipe.CombineJsonFormat;
import de.mari_023.ae2wtlib.wut.recipe.Serializer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;

public interface CombineSerializer
extends Serializer<Combine> {
    public static final String NAME = "combine";

    default public Combine fromJson(ResourceLocation id, JsonObject json) {
        CombineJsonFormat recipeJson = (CombineJsonFormat)new Gson().fromJson((JsonElement)json, CombineJsonFormat.class);
        if (recipeJson.terminalA == null || recipeJson.terminalB == null || this.validateOutput(recipeJson.terminalAName) || this.validateOutput(recipeJson.terminalBName)) {
            throw new JsonSyntaxException("A required attribute is missing or invalid!");
        }
        return new Combine(Ingredient.m_43917_((JsonElement)recipeJson.terminalA), Ingredient.m_43917_((JsonElement)recipeJson.terminalB), recipeJson.terminalAName, recipeJson.terminalBName, id);
    }

    default public void toNetwork(FriendlyByteBuf packetData, Combine recipe) {
        recipe.getTerminalA().m_43923_(packetData);
        recipe.getTerminalB().m_43923_(packetData);
        packetData.m_130070_(recipe.getTerminalAName());
        packetData.m_130070_(recipe.getTerminalBName());
    }

    default public Combine fromNetwork(ResourceLocation id, FriendlyByteBuf packetData) {
        return new Combine(Ingredient.m_43940_((FriendlyByteBuf)packetData), Ingredient.m_43940_((FriendlyByteBuf)packetData), packetData.m_130136_(Short.MAX_VALUE), packetData.m_130136_(Short.MAX_VALUE), id);
    }
}

